/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_05;
import java.io.*; import javax.servlet.*;
import javax.servlet.http.*; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class MyServlet extends HttpServlet implements Servlet {

	/**
	 * Einfaches SingleSignOn Servlet. <br>
	 * Voraussetzungen <br>
	 * - Servlet luft auf einem WebSphere Server. <br>
	 * - WebSphere und Domino basieren auf dem gleichen User Repository (Domino als LDAP) <br>
	 * - WebSphere ist fr SSO eingerichtet, benutzt den Domino als LDAP und allgemeine Sicherheit ist aktiv <br> 
	 * - Der LtpaToken Key wurde von WebSphere exportiert und nach Domino importiert. <br>
	 * - Domino ist fr SSO konfiguriert. <br>
	 * - Beide benutzen die gleiche LDAP Realm (wird beim Import des Keys eingetragen.) <br>
	 * - ber den Webimplementierunsdeskriptor wurde die Sicherheit so eingerichtet,  <br>
	 *    dass sich alle authentifizierten Benutzer anmelden drfen. <br>
	 * - Anzumeldende Benuzter mssen im Domino Directory vorliegen. <br>
	 * - Im Login Fenster als cn=Vorname Nachname, o=ORGANISATION anmelden. <br>
	 *     Dies entspricht einem Domino Benutzer mit Namen "Vorname Nachname/ORGANISATION" <br>
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
		throws ServletException, IOException {
		PrintWriter out = resp.getWriter();
		resp.setContentType("text/html"); 
		out.println ("<html><head>\n" +
				"<title>WebSphere SSO</title>\n<style>\n" +
				"\tbody {font-family:Helvetica,Arial,sans-serif;}\n" +
				"\th1 {color:#FF00FF;}\n</style>\n</head>\n" +
				"<body>\n<h1>WebSphere SSO</h1>\n");

		out.println ("Gefundene Cookies: " + cookieToString(req) + "<br/>");
		Session otherSession = null;
		String token = getToken(req);
		out.println ("<br/>ltpaToken im Cookie = " + token + "<br/>");
		try {

			String host = "localhost:63148";
			otherSession = NotesFactory.createSession(host, token);
			Database db = otherSession.getDatabase("","djbuch/djbuch.nsf");
			out.println ("<br/>Domino Datenbank geffnet: " + db.getTitle() + "<br/>");
			printInfo(otherSession,out);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			recycleSession(otherSession);
		}	
		out.println ("<a href=\"https://localhost:9443/SSOLoginWeb/ibm_security_logout\">logout</a>");
		out.println ("</body></html>");
			
	}

	/**
	 * Das LtpaToken wird vom WebSphere Server vergeben <br>
	 * und kann einfach aus den Cookies extrahiert werden.
	 * @param req
	 * @return
	 */
	private String getToken (HttpServletRequest req) {
		Cookie[] cookie = req.getCookies();
		for (int i = 0; cookie != null && i < cookie.length; i++) {
			if (cookie [i].getName().equalsIgnoreCase("LtpaToken")) {
				return cookie [i].getValue();
				
			}
		}
		return null;
	}

	/**
	 * nur gltige Sessions recyclen (im DIIOP)
	 * @param s
	 */
	private void recycleSession (Session s) {
		try {
			if (s!= null && s.isValid()) {
				s.recycle ();
			}
		} catch (org.omg.CORBA.INV_OBJREF e) {
			//e.printStackTrace(); //ignore. Server might already have closed DIIOP.
		} catch (NotesException e) {
			e.printStackTrace();
		}
	}
	
	/** 
	 * Informationen zur Aufgebauten Domino Session.
	 * @param s - Domino Session
	 * @param out - Ausgabe PrintWriter
	 * @throws NotesException
	 */
	private static void printInfo(Session s, PrintWriter out)
		throws NotesException {
		out.println ("<pre>\nSessionClass\t= " + s.getClass().getName());
		out.println ("Platform\t= " + s.getPlatform());
		out.println ("Version\t\t= " + s.getNotesVersion());
		out.println ("User\t\t= " + s.getUserName());
		out.println ("Session Token\t= " + s.getSessionToken());
		out.println ("Servername\t= <<" + s.getServerName() + ">>\n</pre>");
	}
	
	/**
	 * Redirecten des Posts auf den get.
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse resp)
		throws ServletException, IOException {
		doGet(req,resp);
	}
	
	/**
	 * @param req - der HTTPServlet Request<br>
	 * @return - Die gefundenen Cookies als String in der Form<br>
	 * cookie=value;otherCookie=otherValue<br>
	 */
	private String cookieToString(HttpServletRequest req) {
		String cookieString = "";
		Cookie[] cookie = req.getCookies();
		for (int i = 0; cookie != null && i < cookie.length; i++) {
			cookieString += "<br/>"+cookie[i].getName()
				+ "="
				+ cookie[i].getValue()
				+ ";";
		}
		return cookieString;
	}
}